breed [ neutrons neutron ]
breed [ rods rod ]

globals
[ power
  old-power      ;; seznam poslednch 5 honot energie v ase - pouv se k vpotu prmrn energie
  average-power
  power-change
]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury tlatka Piprav ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to setup
  clear-all
  set-default-shape turtles "circle"
  set power 0
  set old-power [0 0 0 0 0]
  ask patches[ setup-nuclear-fuel ]
  release-neutron
  setup-plot
  plot-power
end

to setup-nuclear-fuel ;; Procedura polek
  if (pcolor = black) and (procento-paliva > (random 100))
  [ set pcolor red ]
end

to setup-plot
  set-current-plot "Energie"
  set-plot-y-range 0 (3 * pozadovana-energie)
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury bhu modelu ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to react
  set power 0
  ask neutrons
  [ fd  1
    if (count neighbors != 8 or any? rods-here)
    [ die ]
    if (pcolor = red)
    [ fission ]
  ]
  calculate-power
  tick
  plot-power
end

to calculate-power
  ;; vypot prmr z poslednch hodnot energie
  set power-change (power - first old-power)
  set old-power fput power but-last old-power
  set average-power mean old-power
end

to auto-react ;; Tlatko
  ifelse (power-change >= 0)
  [ if (pozadovana-energie <= power)
    [ add-rods ]
  ]
  [ if (power < pozadovana-energie)
    [ remove-rods ]
  ]
  react
  if not any? neutrons
  [ stop ]
end

to fission ;; Procedura Neutronu
  rt (random 360)
  if (spotreba-paliva?)
  [ set pcolor brown ]
  let gain (1 / count neutrons-here)
  set power power + gain
  hatch ((2 + random 2) * gain)
  [ rt random 360 ]
end

to release-neutron ;; Tlatko
  let success false
  while [not success]
  [
    create-neutrons 1
    [ set color yellow
      rt (random 360)
      setxy random-pxcor
            random-pycor
      ifelse any? rods-here
      [ die ]
      [ set success true ]
    ]
  ]
end

to add-rods ;; Tlatko
  create-rods pocet-tyci
  [ set color cyan
    setxy random-pxcor
          random-pycor
  ]
end

to remove-rods ;; Tlatko
  ifelse (pocet-tyci >= (count rods))
  [ ask rods [ die ] ]
  [ repeat pocet-tyci
    [ ask one-of rods [ die ] ]
  ]
end

to plot-power
  set-current-plot-pen "pozadovana-energie"
  plot pozadovana-energie
  set-current-plot-pen "prumerna-energie"
  plot average-power
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant pocet-tycis RED #9552950 and REC #9632612.
;
; Copyright 1998 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING
; IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; The project gratefully acknowledges the support of the
; National Science Foundation (REPP & ROLE programs) --
; grant pocet-tycis REC #9814682 and REC-0126227.
; Converted from StarLogoT to NetLogo, 2001.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1998).  NetLogo Reactor Top Down model.
; http://ccl.northwestern.edu/netlogo/models/ReactorTopDown.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/ReactorTopDown
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
344
10
747
434
65
65
3.0
1
10
1
1
1
0
0
0
1
-65
65
-65
65
1
1
1
ticks

CC-WINDOW
5
448
756
543
Command Center
0

SLIDER
9
10
223
43
pozadovana-energie
pozadovana-energie
0.0
100.0
100
1.0
1
NIL
HORIZONTAL

BUTTON
9
119
107
152
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
225
119
340
152
Manul
if not any? neutrons\n[ stop ]\nreact\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
107
119
225
152
Automat
auto-react
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
232
10
334
55
Energie
power
3
1
11

MONITOR
232
60
334
105
Zmna energie
power-change
3
1
11

PLOT
10
257
341
414
Energie
as
energie
0.0
250.0
0.0
60.0
true
true
PENS
"pozadovana-energie" 1.0 0 -13345367 true
"prumerna-energie" 1.0 0 -2674135 true

SWITCH
9
76
157
109
spotreba-paliva?
spotreba-paliva?
1
1
-1000

BUTTON
9
205
103
238
Pidat Tye
add-rods
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
104
205
215
238
Odstranit tye
remove-rods
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
9
43
223
76
procento-paliva
procento-paliva
0.0
100.0
10
1.0
1
%
HORIZONTAL

SLIDER
215
205
339
238
pocet-tyci
pocet-tyci
1
500
200
1
1
NIL
HORIZONTAL

BUTTON
94
162
234
195
Vypustit Neutron
release-neutron
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
CO TO JE?
---------

Tento projekt simuluje reakci jadernho tpen v atomov elektrrn. Pi tpc reakci nar voln neutron na atomy uranu, co zpsobuje pi kad srce vyputn 2 nebo 3 dalch neutron a jedn jednotky energie. Samotn atom uranu se rozpad na dva men atomy. Nov vytvoen neutrony spolu s pvodnm (kter spustil reakci) pokrauj ve svm pohybu a sr se s dalmi atomy uranu, co m za nsledek dal vypoutn neutron atd. Tmto zpsobem vznik etzov reakce uvnit atomov bomby.

Vtina jadern energie je vak vyuvna pedevm pro mrumilovn ely. tpen, vyvolan v atomov elektrrn, probh mnohem vce pod kontrolou. Kryt reaktoru je vytvoen z tlustch plt olova a betonu, kter absorbuj neutrony a chrn tak ped jejich nikem. Reakce je ovldna tyemi, vyrobenmi z grafitu, hafnia, kadmia nebo bru - tyto materily tak absorbuj voln neutrony. Tye jsou pidvny a odebrny z reakn komory za elem kontroly rychlosti reakce. Kdy jsou tye pidny, mn atom uranu je zasaeno neutrony, co omezuje mnostv vytvoen energie.

Model reaktoru simuluje proces jadernho tpen prv v takovto elektrrn. Kryt reaktoru chrn jdro a tye pomhaj ovldat rychlost reakce. Reaktor m zabudovn automatick ovlda, ale lze spustit tak manuln ovldn. 

JAK MODEL OVLDAT
-----------------

Posuvnk POZADOVANA-ENERGIE nastavuje poadovanou produkci energie, kterou chceme z reaktoru zskat (pi pouit automatickho ovldn).

Posuvnk PROCENTO-PALIVA uruje mnostv paliva v reaktoru (erven polka).

Pepna SPOTREBA-PALIVA? uruje, zda se palivo po zsahu neutronem spotebuje (a polko zhndne), i nikoliv.

Tlatka PIDAT TYE a ODEBRAT TYE vkldaj a odebraj tye (svtle modr elvy) v mnostv odpovdajc hodnot posuvnku POCET-TYCI.

Tlatko VYPUSTIT NEUTRON pid do reaktoru dal neutron (lut elvy). Me bt pouito kdykoliv, jak ped reakc, tak v jejm prbhu.

Tlatkem PIPRAV vytvote v modelu reaktor bez ty a s jednm volnm neutronem.

Pokud je stisknut tlatko MANUL, pak je mon pomoc tlatek PIDAT TYE a ODSTRANIT TYE mnit poet ty v reaktoru a tm kontrolovat rychlost reakce a mnostv vytvoen energie. Pokud je v reaktoru pli mlo ty, je absorbovno nedostaten mnostv neutron a vytvo se tak pli mnoho energie. Pokud je ty naopak pli mnoho, dojde k pohlcen vech neutron a nevznikne tak dn energie.

Pokud je model sputn tlatkem AUTOMAT, budou v reaktoru automaticky pidvny a odebrny tye podle aktuln poteby (v dvkch, urench posuvnkem POCET-TYCI), m je zajitno, e je reakce pod kontrolou.

Ukazatel ENERGIE zobrazuje aktuln mnostv reaktorem produkovan energie.

Ukazatel ZMENA-ENERGIE zobrazuje zmnu v mnostv vyprodukovan energie oproti minulmu asovmu kroku.

V grafu ENERGIE lze sledovat kivku reprezentujc mnostv vytvoen energie v ase. 

VIMNTE SI
-----------

Sledujte vchylky erven kivky energie v grafu. Modr ra reprezentuje poadovan mnostv energie (odpovdajc hodnot posuvnku POZADOVANA-ENERGIE), zatmco erven kivka vykresluje skuten vyprodukovan mnostv energie. 

VYZKOUEJTE SI
--------------

Existuj dva zpsoby ovldn, ve kterch me bt model reaktoru sputn - manuln a automatick.

V manulnm mdu je ovldn velmi jednoduch. Mnostv ty v reaktoru je regulovno pomoc tlatek PIDAT-TYE a ODSTRANIT-TYE.

Automatick ovldn je v podstat spna, zaloen na jednoduchch pravidlech. Tento zpsob ovldn zvis na dvou faktorech (mechanismus je popsn v nsledujc tabulce):

1) na rozdlu mezi aktuln vytvenou a poadovanou energi;

2) na zmn v produkci energie oproti minulmu asovmu kroku.

                     Energie > Poadovan energie   Energie < Poadovan energie                      ----------------------------   ---------------------------   Zmna Energie > 0:          Pidej tye                    Nedlej nic      Zmna energie < 0:          Nedlej nic                    Odstra tye

elem obou zpsob ovldn je dolaovat mnostv vyroben energie na poadovanou rove.

* V manulnm mdu

Pouijte posuvnk POCET-TYCI k pizpsoben mnostv pidvanch a odstraovanch ty podle informac zobrazench v grafu a pomoc zmnnch ukazatel. Vam kolem je zskat takovou ervenou kivku, kter by byla co nejvce rovn (konstantn) a pokud mono koprovala rovnou modrou ru, reprezentujc poadovan mnostv energie.

* V automatickm mdu

Zde psob ve uveden pravidla, kter zpsobuj minimalizaci kolsn kolem hladiny poadovan energie.

Pepna SPOTEBA-PALIVA uruje, zda je palivo po vyputn novch neutronu spotebovno, i nikoliv. Pokud je v poloze ON (zapnuto), pak v modelu rychle dojde ke spotebovn vekerho dostupnho paliva a model se zastav. Kvli rychl spoteb a nutnosti doplovat nov palivo je v tomto ppad nejvhodnj mt v reaktoru vysok mnostv paliva a udrovat nzkou hladinu produkovan energie. Pokud je pepna v poloze OFF (vypnuto), pak nikdy nedojde ke spotebovn paliva, kter tak bude reagovat pi kad srce s neutrony a bh modelu se zejm nikdy nezastav. Z dvodu vysok reaktivnosti a dlouhho trvn je vhodn mt mn paliva (jinak me dojt k nekontrolovateln etzov reakci) a odebrat vysok mnostv energie, aby nemusel bt reaktor po celou dobu zaplnn tyemi. 

ROZEN MODELU
----------------

Automatick ovldn funguje pouze jako spna provdn instrukc. Zkuste pout proporcionln integran a derivan regultor (PID), aby byla reakce vce plynul. Mete tak pout nkter mylenky fuzzy logiky (resp. fuzzy mnoin) k vytvoen fuzzy ovldn.

Pohlcovn volnch neutron za elem kontroly reaknho procesu je pouze jeden z kontrolnch mechanism a dokonce nen ani tm nejdleitjm. Dalm zpsobem, jak dit reakci je udrovat rychlost neutronu ni ne je urit rove (pro stimulaci tpc reakce). Rychlost neutron zvis na hustot pry. Vy hustota zpsobuje ni rychlost a naopak. Pokud je mnostv vytvoen energie vysok, pak je teplota pry vysok a jej hustota je nzk - to zpsobuje vysokou rychlost pohybu neutronu, co zpomaluje tpen. Pi nzkm mnostv vytven energie je tomu naopak. Zkuste tento proces zakomponovat do automatickho ovldn.

Ani nastaven SPOTREBA-PALIVA? nen zcela realistick. Pokud je tento spna zapnut, pak je palivo spotebovno pli rychle a sotva dojde k reakci. Pokud je vypnut, dochz naopak k pli intenzivn reakci a je teba mnoho ty k jej kontrole. Ne naleznete dva zpsoby, jak tuto situaci vyeit. Vymyslte njak dal?

1) Kad erven polko paliva by mohlo obsahovat jist mnostv paliva, kter by nebylo spotebovno pi srce s neutronem narz, ale zrove by postupn dolo k jeho vyerpn.

2) Dal zpsob je omezit, jak asto mohou polka paliva reagovat. Pi vypnut spnae SPOTREBA-PALIVA? by tak nedochzelo k nekontrolovatelnm reakcm v malch oblastech. 

SOUVISEJC MODELY
------------------

Spolu s modelem Reactor X-section mete zskat zkladn pehled o tom, jak me ve tech dimenzch fungovat jadern reaktor. Tyto dva modely jsou obdobou starho modelu Fission (tpen) z jazyka StarLogoT. 

PROGRAMOVAC ZAJMAVOSTI NETLOGA
--------------------------------

V tomto modelu hraje graf vce aktivn roli ne u vtiny ostatnch model NetLoga. Pi pouit manulnho ovldn je velmi uiten sledovat kivku energie, aby bylo mon urit, kdy se reakce vymkne kontrole.


PODKOVN A ODKAZY
----------------------
Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Wilensky, U. (1998).  NetLogo Reactor Top Down model.  http://ccl.northwestern.edu/netlogo/models/ReactorTopDown.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace:  Copyright 1998 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/ReactorTopDown for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
setup
repeat 60 [ auto-react ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
